SELECT 
	ISNULL(TempTableMappings.MapFromField, columns.name) AS FileColumnName,
	CAST(columns.name AS VARCHAR(50)) AS MapToOutPut, 
	CASE LOWER(systypes.name)
		WHEN 'bigint' THEN 'System.Int64'
		WHEN 'bit' THEN 'System.Boolean'
		WHEN 'datetime' THEN 'System.DateTime'
		WHEN 'decimal' THEN 'System.Decimal'
		WHEN 'float' THEN 'System.Double'
		WHEN 'int' THEN 'System.Int32'
		WHEN 'money' THEN 'System.Decimal'
		WHEN 'numeric' THEN 'System.Decimal'
		WHEN 'real' THEN 'System.Single'
		WHEN 'smalldatetime' THEN 'System.DateTime'
		WHEN 'smallint' THEN 'System.Int16'
		WHEN 'smallmoney' THEN 'System.Decimal'
		WHEN 'tinyint' THEN 'System.Byte'
		WHEN 'uniqueidentifier' THEN 'System.Guid'
  		ELSE 'System.String'
	END AS OutputDataTypeName, 
 	columns.is_nullable AS IsNullable
FROM sys.columns 
INNER JOIN sys.tables 
	ON columns.object_id = tables.object_id
INNER JOIN sys.systypes 
	ON columns.system_type_id = systypes.xtype
LEFT JOIN dbo.TempTableMappings
	ON columns.name = TempTableMappings.MapToField
	AND TempTableMappings.MappingFormatID = ?
WHERE tables.name = N'TempTable' 
ORDER BY columns.column_id